<?php defined( 'ABSPATH' ) OR die( 'This script cannot be accessed directly.' ); 
add_action( 'plugins_loaded', function () {

  if ( function_exists( 'determine_locale' ) ) {
    $locale = determine_locale();
  } elseif ( function_exists( 'get_user_locale' ) && is_admin() ) {
    $locale = get_user_locale();
  } elseif ( function_exists( 'get_locale' ) ) {
    $locale = get_locale();
  } else {
    $locale = 'fa_IR';
  }

  if ( $locale === 'fa_IR' ) {
    add_filter( 'gettext', 'abazrwp_gettext_woo_add_to_cart' );
    add_filter( 'ngettext', 'abazrwp_gettext_woo_add_to_cart' );
  }

  function abazrwp_gettext_woo_add_to_cart( $translated ) {

    $words      = [
      'افزودن به سبد خرید' => 'ثبت نام در دوره'
    ];

    return str_ireplace( array_keys( $words ), $words, $translated );
  }

}, 999 );